-- Educated_Elite.lua
-- Author: Machiavelli
-- DateCreated: 7/23/2012 4:03:07 PM
--------------------------------------------------------------
function GiveInfluenceWhenGreatPersonCreated(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	local player = Players[playerID];
	local unit = player:GetUnitByID(unitID);
	local policyID = GameInfoTypes["POLICY_EDUCATED_ELITE"];

	-- Only give the Culture if the player has the policy and this is a great person
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and unit:IsGreatPerson()) then
		local minorTrait = "";

		if(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_MERCHANT"]) then
			minorTrait = MinorCivTraitTypes.MINOR_CIV_TRAIT_MERCANTILE;
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_SCIENTIST"]) then
			minorTrait = MinorCivTraitTypes.MINOR_CIV_TRAIT_MARITIME;
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_GREAT_GENERAL"] or unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_GREAT_ADMIRAL"]) then
			minorTrait = MinorCivTraitTypes.MINOR_CIV_TRAIT_MILITARISTIC;
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_ARTIST"]) then
			minorTrait = MinorCivTraitTypes.MINOR_CIV_TRAIT_CULTURED;
		elseif(unit:GetUnitClassType() == GameInfoTypes["UNITCLASS_ENGINEER"]) then
			minorTrait = MinorCivTraitTypes.MINOR_CIV_TRAIT_RELIGIOUS;
		end

		-- If the unit isn't one of the above Great People don't continue
		if(minorTrait == "") then
			return;
		end

		-- Notification string that will be built in the minor civilizations loop
		local ListOfMinorsImpressed = "";

		-- Give the influence
		--for minorCiv in Players do
		for index = GameDefines.MAX_MAJOR_CIVS, GameDefines.MAX_CIV_PLAYERS-1, 1 do
			local minorCiv = Players[index];

			-- Only run if the player is a minor civilization that is alive
			-- the player has met them and they are at peace
			-- the minor's trait matches the trait for this great person
			if(minorCiv:IsMinorCiv() and minorCiv:IsAlive() and
			   Teams[player:GetTeam()]:IsHasMet(minorCiv:GetTeam()) and not Teams[player:GetTeam()]:IsAtWar(minorCiv:GetTeam()) and
			   minorCiv:GetMinorCivTrait() == minorTrait) then
				-- Add this minor civilization to the list to be used in the notification
				ListOfMinorsImpressed = ListOfMinorsImpressed .. "[NEWLINE][ICON_BULLET]" .. minorCiv:GetName();

				-- Give influence
				minorCiv:ChangeMinorCivFriendshipWithMajor(playerID, 25);
			end
		end

		-- Send a notification to the player if any City-State was influenced
		if(ListOfMinorsImpressed ~= "") then
			local header = Locale.ConvertTextKey("TXT_KEY_CITY_STATES_INFLUENCED_BY_GREAT_PERSON_HEADER", unit:GetName());
			local text = Locale.ConvertTextKey("TXT_KEY_CITY_STATES_INFLUENCED_BY_GREAT_PERSON", ListOfMinorsImpressed);

			player:AddNotification(NotificationTypes.NOTIFICATION_MINOR, text, header);
		end
	end
end
LuaEvents.SerialEventUnitCreatedGood.Add(GiveInfluenceWhenGreatPersonCreated);